/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client;

import com.agricraft.agricraft.client.gui.JournalScreen;
import com.agricraft.agricraft.common.block.CropStickVariant;
import com.agricraft.agricraft.common.item.JournalItem;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_727;

public class ClientUtil {
    public static String getModelForSticks(CropStickVariant variant) {
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case CropStickVariant.WOODEN -> "agricraft:block/wooden_crop_sticks";
            case CropStickVariant.IRON -> "agricraft:block/iron_crop_sticks";
            case CropStickVariant.OBSIDIAN -> "agricraft:block/obsidian_crop_sticks";
        };
    }

    public static void spawnParticlesForPlant(String plantModelId, class_1936 level, class_2680 state, class_2338 pos, class_265 voxelShape) {
        class_1087 model = (class_1087)class_310.method_1551().method_1554().field_5408.get(new class_2960(plantModelId));
        ClientUtil.spawnParticlesForShape(model, level, state, pos, voxelShape);
    }

    public static void spawnParticlesForSticks(CropStickVariant variant, class_1936 level, class_2680 state, class_2338 pos, class_265 voxelShape) {
        String modelId = ClientUtil.getModelForSticks(variant);
        class_1087 model = (class_1087)class_310.method_1551().method_1554().field_5408.get(new class_2960(modelId));
        ClientUtil.spawnParticlesForShape(model, level, state, pos, voxelShape);
    }

    public static void spawnParticlesForShape(class_1087 model, class_1936 level, class_2680 state, class_2338 pos, class_265 voxelShape) {
        if (model == null) {
            return;
        }
        class_1058 particleIcon = model.method_4711();
        voxelShape.method_1089((startX, startY, startZ, endX, endY, endZ) -> {
            double xBoxes = Math.min(1.0, endX - startX);
            double yBoxes = Math.min(1.0, endY - startY);
            double zBoxes = Math.min(1.0, endZ - startZ);
            int maxX = Math.max(2, class_3532.method_15384((double)(xBoxes / 0.25)));
            int maxY = Math.max(2, class_3532.method_15384((double)(yBoxes / 0.25)));
            int maxZ = Math.max(2, class_3532.method_15384((double)(zBoxes / 0.25)));
            for (int p = 0; p < maxX; ++p) {
                for (int q = 0; q < maxY; ++q) {
                    for (int r = 0; r < maxZ; ++r) {
                        double dx = ((double)p + 0.5) / (double)maxX;
                        double dy = ((double)q + 0.5) / (double)maxY;
                        double dz = ((double)r + 0.5) / (double)maxZ;
                        double ox = dx * xBoxes + startX;
                        double oy = dy * yBoxes + startY;
                        double oz = dz * zBoxes + startZ;
                        class_727 particle = new class_727((class_638)level, (double)pos.method_10263() + ox, (double)pos.method_10264() + oy, (double)pos.method_10260() + oz, dx - 0.5, dy - 0.5, dz - 0.5, state, pos);
                        particle.method_18141(particleIcon);
                        class_310.method_1551().field_1713.method_3058((class_703)particle);
                    }
                }
            }
        });
    }

    public static void openJournalScreen(class_1657 player, class_1268 hand) {
        class_310.method_1551().method_1507((class_437)new JournalScreen(JournalItem.getJournalData(player.method_5998(hand))));
    }
}

